﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

namespace Reversi
{
    class ReversiSilnik
    {
        public const int planszaSzer = 8;
        public const int planszaWys = 8;
        private int[,] plansza = new int[planszaSzer, planszaWys];
        //public enum MozliwyStanPola {Puste=0, Gracz1=1, Gracz2=2};
        private int numerGraczaWykonujacegoNastepnyRuch = 1;        

        public int StanPola(int poziomo, int pionowo)
        {
            if (poziomo < 0 || poziomo >= planszaSzer ||
                pionowo < 0 || pionowo >= planszaWys)
                throw new Exception("Nieprawidłowe współrzędne pola");
            return plansza[poziomo, pionowo];
        }

        /*
        public int StanPola(string pole)
        {
            if (pole.Length != 2) throw new Exception("Nieprawidłowy symbol pola");
            int poziomo = (int)pole.ToUpper()[0] - (int)'A';
            int pionowo = int.Parse(pole[1].ToString()) - 1;
            return StanPola(poziomo, pionowo);
        }
        */

        public int NumerGraczaWykonujacegoNastepnyRuch
        {
            get
            {
                return numerGraczaWykonujacegoNastepnyRuch;
            }
        }

        public ReversiSilnik(int numerGraczaRozpoczynajacego)
        {
            for (int i = 0; i < planszaSzer; i++)
                for (int j = 0; j < planszaWys; j++)
                    plansza[i, j] = 0;

            int srodekSzer = planszaSzer / 2;
            int srodekWys = planszaWys / 2;
            plansza[srodekSzer - 1, srodekWys - 1] = plansza[srodekSzer, srodekWys] = 1;
            plansza[srodekSzer - 1, srodekWys] = plansza[srodekSzer, srodekWys - 1] = 2;

            numerGraczaWykonujacegoNastepnyRuch = numerGraczaRozpoczynajacego;
        }

        public bool PolozKamien(int poziomo, int pionowo)
        {
            //czy prawidlowe wspolrzedne
            if (poziomo < 0 || poziomo >= planszaSzer || pionowo < 0 || pionowo >= planszaWys)
                throw new Exception("Nieprawidłowe współrzędne pola");

            //czy pole nie jest juz zajete?
            if (plansza[poziomo, pionowo] != 0) return false;

            bool poprawnyRuch = false;

            //petla po 8 kierunkach
            for (int kierunekPoziomo = -1; kierunekPoziomo <= 1; kierunekPoziomo++)
                for (int kierunekPionowo = -1; kierunekPionowo <= 1; kierunekPionowo++)
                {
                    //wymuszenie pominiecia przypadku gdy obie zmienne rowne 0
                    if (kierunekPoziomo == 0 && kierunekPionowo == 0) continue;

                    //szukanie pionkow gracza w jednym z 8 kierunkow
                    //int kierunekPoziomo = 1;
                    //int kierunekPionowo = 0;
                    int i = poziomo;
                    int j = pionowo;
                    bool znalezionyKamienPrzeciwnika = false;
                    bool znalezionyKamienGraczaWykonujacegoRuch = false;
                    bool znalezionePustePole = false;
                    bool osiagnietaKrawedzPlanszy = false;
                    do
                    {
                        i += kierunekPoziomo;
                        j += kierunekPionowo;
                        if (i < 0 || j < 0 || i >= planszaSzer || j >= planszaWys) osiagnietaKrawedzPlanszy = true;
                        if (!osiagnietaKrawedzPlanszy)
                        {
                            if (plansza[i, j] == numerGraczaWykonujacegoNastepnyRuch)
                                znalezionyKamienGraczaWykonujacegoRuch = true;
                            if (plansza[i, j] == 0)
                                znalezionePustePole = true;
                            if (plansza[i, j] == ((numerGraczaWykonujacegoNastepnyRuch == 1) ? 2 : 1))
                                znalezionyKamienPrzeciwnika = true;
                        }
                    }
                    while (!(osiagnietaKrawedzPlanszy || znalezionyKamienGraczaWykonujacegoRuch || znalezionePustePole));

                    //sprawdzenie warunku poprawnosci ruchu
                    bool mozliwePolozenieKamienia = (znalezionyKamienPrzeciwnika && znalezionyKamienGraczaWykonujacegoRuch && !znalezionePustePole);

                    //odwrocenie pionkow w przypadku spelnionego warunku
                    if (mozliwePolozenieKamienia)
                    {
                        int maks_indeks = Math.Max(Math.Abs(i - poziomo), Math.Abs(j - pionowo));
                        for (int indeks = 0; indeks < maks_indeks; indeks++)
                            plansza[poziomo + indeks * kierunekPoziomo, pionowo + indeks * kierunekPionowo] = numerGraczaWykonujacegoNastepnyRuch;

                        poprawnyRuch = true;
                    }
                } //koniec petli po kierunkach

            //jezeli ruch zostal wykonany - zmiana gracza
            if (poprawnyRuch)
            {
                numerGraczaWykonujacegoNastepnyRuch = ((numerGraczaWykonujacegoNastepnyRuch == 1) ? 2 : 1);                
            }

            return poprawnyRuch;
        }
    }
}
